library(raster)
library(scales)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/CSV/'
ndviDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/NDVI/'
AHNDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/Hellegat AHN/'

# GPS Coordinate information
setwd(ndviDirectory)
NDVI = raster('g_Westerschelde_2016_NDVI_Hellegat.tif')
NDVI = extend(NDVI, extent(NDVI) + c(0,0,0,100))
NDVI[is.na(NDVI)] = 0
NDVIinset = crop(NDVI, extent(54700,  54880, 376220, 376400))
yPos = 376440
xPos = 55100
main = 'Hellegat'
xlim = c(54380,55270)
breaks = c(-0.16,0.1,1)
scaleBarxy = c(54430, 376590)


# Hellegat's oyster survival plots -----------

tiff('Figure 3d.tiff', width = 20, height = 20, units = "cm", res = 300)
plot(NDVIinset, breaks = breaks, col = colSeq, bty = 'n',
     xaxt = 'n', yaxt = 'n', box = F, legend = F)
scaleBarxy = c(54845,376390)
scalebar(d = 25, label = '25 m', xy = scaleBarxy, cex = 1.4)

setwd(csvDirectory)
d = read.csv('Hellegat oyster survival plots.csv')
d$plot.type = factor(d$plot.type)
col = alpha(colorRampPalette(c('black','grey'))(3), 0.8)
pch = 21:23
d$y.RD[d$plot.type == 'Mudflat'][3] = d$y.RD[d$plot.type == 'Mudflat'][3] + 5
d$x.RD[d$plot.type == 'Mudflat'][3] = d$x.RD[d$plot.type == 'Mudflat'][3] - 3
d$x.RD[d$plot.type == 'Saltmarsh'][4] = d$x.RD[d$plot.type == 'Saltmarsh'][4] + 2
d$y.RD[d$plot.type == 'Saltmarsh'][3] = d$y.RD[d$plot.type == 'Saltmarsh'][3] + 2
d$x.RD[d$plot.type == 'Saltmarsh'][2] = d$x.RD[d$plot.type == 'Saltmarsh'][2] + 2
d$x.RD[d$plot.type == 'Protected mudflat'][1] = d$x.RD[d$plot.type == 'Protected mudflat'][1] - 0.5
d$y.RD[d$plot.type == 'Protected mudflat'][2] = d$y.RD[d$plot.type == 'Protected mudflat'][2] - 2.2
d$x.RD[d$plot.type == 'Protected mudflat'][2] = d$x.RD[d$plot.type == 'Protected mudflat'][2] + 0.7
d$x.RD[d$plot.type == 'Protected mudflat'][1] = d$x.RD[d$plot.type == 'Protected mudflat'][1] - 2
d$y.RD[d$plot.type == 'Protected mudflat'][c(1,3)] = d$y.RD[d$plot.type == 'Protected mudflat'][c(1,3)] - 3
points(d$y.RD ~ d$x.RD, pch = pch[d$plot.type], bg = col[d$plot.type], cex = 1.5)
range(d$y.RD)

# Legend ---------
yPos = 376400
xPos = 54705
rect(xleft = xPos, xright = xPos + 80, ybottom = yPos - 40, ytop = yPos, col = 'white')
offset = c(10, 45,75,110)#seq(-30,110,length.out = 5) 
points(x = rep(xPos + 10, times = 3), y = yPos - seq(10,30,length.out = 3),
       cex = 2,
       bg = rev(col),#bg = alpha('green',0.5),
       pch = rev(pch))#pch = 21)
text = c('Saltmarsh', 'Protected mudflat','Mudflat')
offset = seq(20,115,length.out = 4)
text(x = xPos + c(11,15,10)*3, 
     y = yPos - seq(3,10,length.out = 3)*3, 
     cex = 1.4,
     text)
setwd(figureDirectory)
dev.off()


# -----------------
# In-text statistical information
# Experiment's inundation frequency range

setwd(csvDirectory)
d = read.csv('Hellegat oyster survival plots.csv')
coordinates(d)= ~ x.RD + y.RD
d$inundFreq = extract(inundFreqR, d)
mean = round(mean(d$inundFreq),2)
se = round(sd(d$inundFreq)/sqrt(length(d$inundFreq)),2)
print(paste(mean, '  ', se))
range(d$inundFreq)
